
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Dec 14 15:05:13 2004
   *  Last modified   :  %modify_time%
   */
  /** @file 
   *  \brief A brief C2cription of this module 
   *
   *  \version CRYS_ATP_TST_C2_Acceptance_test_vectors.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
    
/* disabling pc lint warning regarding to few initializers in braces :
   Too few initializers for aggregate 'unknown-name' */ 
/*lint --e{785} */   
    
/*****************************************************************************
 * File Name:                                                           
 *  CRYS_ATP_TST_C2_Acceptance_test_vectors.c      
 *
 * C2cription:                                                                 
 *  This file contatins the test vectors used for C2 Acceptance tests                              
 *
 ******************************************************************************/

/************* Include Files ****************/
#include "CRYS_error.h" 
#include "CRYS_ATP_TST_C2_Acceptance.h"
/************************ Defines ************************/ 
/************************ Enums **************************/ 
/************************ Typedefs ***********************/ 
/************************ Global Data ********************/ 
/************* Private function prototype ****************/ 
/************************ Public Functions ***************/ 
/************************ Private Functions **************/ 

TST_C2_TestDataStruct TST_C2_Acceptance_TestData[] =
{
        /**********************************/
        /*        C2 ECB vectors         */
        /**********************************/
    { 
        {"Acceptance test - C2/ECB/1-Key/8-ByteData "},
        /*TST_Key*/ 
        { 0x5e, 0x91, 0x6a, 0xef, 0x34, 0x1f, 0xa3},    
        /*TST_input_data*/
		{0x2b, 0x7f, 0x06, 0x89, 0x6f, 0x0d, 0xa6, 0xe2},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/ 
		{0xe4,0x5f,0xe6,0x8f,0x05,0x80,0xba,0xf7},
        /*TST_dataSize*/
        8*sizeof(DxUint8_t),       
        CRYS_C2_ECB_mode 
    },
    
	{ 
        {"Acceptance test - C2/ECB/1-Key/32ByteData "},
        /*TST_Key*/ 
        { 0x5e, 0x91, 0x6a, 0xef, 0x34, 0x1f, 0xa3},
        /*TST_input_data*/
        {0x4e,0x6f,0x77,0x20,0x69,0x73,0x20,0x74,0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
         0x3f,0xa4,0x0e,0x8a,0x98,0x4d,0x48,0x15,0x44,0x08,0xf0,0xa4,0x6e,0xaf,0x29,0xeb},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/ 
        {0x65 ,0xC1 ,0x68 ,0x89 ,0xC1 ,0x8F ,0x49 ,0x68 ,0xD8 ,0x22 ,0xA5 ,0xBD ,0xAD ,0x88 
		,0x8F ,0x3D ,0x77 ,0xE4 ,0x84 ,0xE0 ,0xDC ,0xE4 ,0xB5 ,0x72 ,0x8E ,0x42 ,0x91 ,0x48
		,0x8D ,0x0E ,0x70 ,0x00  },  
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),     
        CRYS_C2_ECB_mode 
    },


	    { 
        {"Acceptance test - C2/ECB/1-Key/512ByteData "},
        /*TST_Key*/ 
        {0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd},
        
                /*TST_input_data*/
        {0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/ 
        {0xB0,0x02,0x3F,0x68,0x87,0x09,0x34,0x7A,0xFE,0x7F,0x27,0x49,0x1D,0xF2,0xB4,0xAA,
		0x86,0xB9,0x38,0xF8,0x42,0x57,0x99,0x4B,0x33,0x8C,0xD4,0x24,0xF5,0xF0,0x38,0x4D,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0x36,0x97,0x55,0xDA,0x6C,0x10,0x79,0xA6,0x48,0xCF,0x84,0x9A,0xCF,0x9B,0x5E,0x2B,
		0x25,0x4F,0xE7,0x06,0x51,0x23,0x1A,0x5F,0xAC,0xCF,0xA4,0x33,0xAF,0xCC,0x63,0x3B,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0xB0,0x02,0x3F,0x68,0x87,0x09,0x34,0x7A,0xFE,0x7F,0x27,0x49,0x1D,0xF2,0xB4,0xAA,
		0x86,0xB9,0x38,0xF8,0x42,0x57,0x99,0x4B,0x33,0x8C,0xD4,0x24,0xF5,0xF0,0x38,0x4D,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0x36,0x97,0x55,0xDA,0x6C,0x10,0x79,0xA6,0x48,0xCF,0x84,0x9A,0xCF,0x9B,0x5E,0x2B,
		0x25,0x4F,0xE7,0x06,0x51,0x23,0x1A,0x5F,0xAC,0xCF,0xA4,0x33,0xAF,0xCC,0x63,0x3B,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0xB0,0x02,0x3F,0x68,0x87,0x09,0x34,0x7A,0xFE,0x7F,0x27,0x49,0x1D,0xF2,0xB4,0xAA,
		0x86,0xB9,0x38,0xF8,0x42,0x57,0x99,0x4B,0x33,0x8C,0xD4,0x24,0xF5,0xF0,0x38,0x4D,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0x36,0x97,0x55,0xDA,0x6C,0x10,0x79,0xA6,0x48,0xCF,0x84,0x9A,0xCF,0x9B,0x5E,0x2B,
		0x25,0x4F,0xE7,0x06,0x51,0x23,0x1A,0x5F,0xAC,0xCF,0xA4,0x33,0xAF,0xCC,0x63,0x3B,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0xB0,0x02,0x3F,0x68,0x87,0x09,0x34,0x7A,0xFE,0x7F,0x27,0x49,0x1D,0xF2,0xB4,0xAA,
		0x86,0xB9,0x38,0xF8,0x42,0x57,0x99,0x4B,0x33,0x8C,0xD4,0x24,0xF5,0xF0,0x38,0x4D,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0x36,0x97,0x55,0xDA,0x6C,0x10,0x79,0xA6,0x48,0xCF,0x84,0x9A,0xCF,0x9B,0x5E,0x2B,
		0x25,0x4F,0xE7,0x06,0x51,0x23,0x1A,0x5F,0xAC,0xCF,0xA4,0x33,0xAF,0xCC,0x63,0x3B,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98},  
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),        
        CRYS_C2_ECB_mode 
    },
	    { 
        {"Acceptance test - C2/ECB/1-Key/512ByteData "},
        /*TST_Key*/ 
        {0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd},
        
                /*TST_input_data*/
        {0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
		0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/ 
        {0xB0,0x02,0x3F,0x68,0x87,0x09,0x34,0x7A,0xFE,0x7F,0x27,0x49,0x1D,0xF2,0xB4,0xAA,
		0x86,0xB9,0x38,0xF8,0x42,0x57,0x99,0x4B,0x33,0x8C,0xD4,0x24,0xF5,0xF0,0x38,0x4D,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0x36,0x97,0x55,0xDA,0x6C,0x10,0x79,0xA6,0x48,0xCF,0x84,0x9A,0xCF,0x9B,0x5E,0x2B,
		0x25,0x4F,0xE7,0x06,0x51,0x23,0x1A,0x5F,0xAC,0xCF,0xA4,0x33,0xAF,0xCC,0x63,0x3B,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0xB0,0x02,0x3F,0x68,0x87,0x09,0x34,0x7A,0xFE,0x7F,0x27,0x49,0x1D,0xF2,0xB4,0xAA,
		0x86,0xB9,0x38,0xF8,0x42,0x57,0x99,0x4B,0x33,0x8C,0xD4,0x24,0xF5,0xF0,0x38,0x4D,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0x36,0x97,0x55,0xDA,0x6C,0x10,0x79,0xA6,0x48,0xCF,0x84,0x9A,0xCF,0x9B,0x5E,0x2B,
		0x25,0x4F,0xE7,0x06,0x51,0x23,0x1A,0x5F,0xAC,0xCF,0xA4,0x33,0xAF,0xCC,0x63,0x3B,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0xB0,0x02,0x3F,0x68,0x87,0x09,0x34,0x7A,0xFE,0x7F,0x27,0x49,0x1D,0xF2,0xB4,0xAA,
		0x86,0xB9,0x38,0xF8,0x42,0x57,0x99,0x4B,0x33,0x8C,0xD4,0x24,0xF5,0xF0,0x38,0x4D,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0x36,0x97,0x55,0xDA,0x6C,0x10,0x79,0xA6,0x48,0xCF,0x84,0x9A,0xCF,0x9B,0x5E,0x2B,
		0x25,0x4F,0xE7,0x06,0x51,0x23,0x1A,0x5F,0xAC,0xCF,0xA4,0x33,0xAF,0xCC,0x63,0x3B,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0xB0,0x02,0x3F,0x68,0x87,0x09,0x34,0x7A,0xFE,0x7F,0x27,0x49,0x1D,0xF2,0xB4,0xAA,
		0x86,0xB9,0x38,0xF8,0x42,0x57,0x99,0x4B,0x33,0x8C,0xD4,0x24,0xF5,0xF0,0x38,0x4D,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0x36,0x97,0x55,0xDA,0x6C,0x10,0x79,0xA6,0x48,0xCF,0x84,0x9A,0xCF,0x9B,0x5E,0x2B,
		0x25,0x4F,0xE7,0x06,0x51,0x23,0x1A,0x5F,0xAC,0xCF,0xA4,0x33,0xAF,0xCC,0x63,0x3B,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0xB0,0x02,0x3F,0x68,0x87,0x09,0x34,0x7A,0xFE,0x7F,0x27,0x49,0x1D,0xF2,0xB4,0xAA,
		0x86,0xB9,0x38,0xF8,0x42,0x57,0x99,0x4B,0x33,0x8C,0xD4,0x24,0xF5,0xF0,0x38,0x4D,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0x36,0x97,0x55,0xDA,0x6C,0x10,0x79,0xA6,0x48,0xCF,0x84,0x9A,0xCF,0x9B,0x5E,0x2B,
		0x25,0x4F,0xE7,0x06,0x51,0x23,0x1A,0x5F,0xAC,0xCF,0xA4,0x33,0xAF,0xCC,0x63,0x3B,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0xB0,0x02,0x3F,0x68,0x87,0x09,0x34,0x7A,0xFE,0x7F,0x27,0x49,0x1D,0xF2,0xB4,0xAA,
		0x86,0xB9,0x38,0xF8,0x42,0x57,0x99,0x4B,0x33,0x8C,0xD4,0x24,0xF5,0xF0,0x38,0x4D,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0x36,0x97,0x55,0xDA,0x6C,0x10,0x79,0xA6,0x48,0xCF,0x84,0x9A,0xCF,0x9B,0x5E,0x2B,
		0x25,0x4F,0xE7,0x06,0x51,0x23,0x1A,0x5F,0xAC,0xCF,0xA4,0x33,0xAF,0xCC,0x63,0x3B,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0xB0,0x02,0x3F,0x68,0x87,0x09,0x34,0x7A,0xFE,0x7F,0x27,0x49,0x1D,0xF2,0xB4,0xAA,
		0x86,0xB9,0x38,0xF8,0x42,0x57,0x99,0x4B,0x33,0x8C,0xD4,0x24,0xF5,0xF0,0x38,0x4D,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0x36,0x97,0x55,0xDA,0x6C,0x10,0x79,0xA6,0x48,0xCF,0x84,0x9A,0xCF,0x9B,0x5E,0x2B,
		0x25,0x4F,0xE7,0x06,0x51,0x23,0x1A,0x5F,0xAC,0xCF,0xA4,0x33,0xAF,0xCC,0x63,0x3B,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0xB0,0x02,0x3F,0x68,0x87,0x09,0x34,0x7A,0xFE,0x7F,0x27,0x49,0x1D,0xF2,0xB4,0xAA,
		0x86,0xB9,0x38,0xF8,0x42,0x57,0x99,0x4B,0x33,0x8C,0xD4,0x24,0xF5,0xF0,0x38,0x4D,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98,
		0x36,0x97,0x55,0xDA,0x6C,0x10,0x79,0xA6,0x48,0xCF,0x84,0x9A,0xCF,0x9B,0x5E,0x2B,
		0x25,0x4F,0xE7,0x06,0x51,0x23,0x1A,0x5F,0xAC,0xCF,0xA4,0x33,0xAF,0xCC,0x63,0x3B,
		0x8A,0xF6,0x44,0x73,0x16,0x08,0x8E,0x3E,0x47,0xBF,0xB6,0x69,0x1A,0x8A,0xD4,0x04,
		0xA7,0x59,0x71,0x7A,0xDC,0xB5,0x30,0x47,0xA2,0x01,0x6C,0x1B,0x8A,0xDB,0x37,0x98},  
        /*TST_dataSize*/
        1024*sizeof(DxUint8_t),        
        CRYS_C2_ECB_mode 
    },


        /**********************************/
        /*        C2 CBC vectors         */
        /**********************************/
  { 
        {"Acceptance test - C2/CBC/1-Key/8-ByteData "},
        /*TST_Key*/ 
        {  0x01, 0x03, 0x05, 0x07, 0x09, 0x11, 0x13},
       
 
        /*TST_input_data*/
		{0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9},
		
	
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/ 
		{0x8D ,0x78 ,0x84 ,0x5F ,0xDC ,0xFA ,0x4F ,0x45},
   
        /*TST_dataSize*/
        8*sizeof(DxUint8_t),       
        CRYS_C2_CBC_mode 
    },   
	{ 
        {"Acceptance test - C2/CBC/1-Key/32-ByteData "},
        /*TST_Key*/ 
        {  0x01, 0x03, 0x05, 0x07, 0x09, 0x11, 0x13},
       
 
        /*TST_input_data*/
		{0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9},
		
	
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/ 
		{0x8D,0x78,0x84,0x5F,0xDC,0xFA,0x4F,0x45,0xD9,0x03,0x30,0x0A,
		 0x5D,0xF7,0x0B,0x94,0xB2,0x69,0x0B,0xC7,0xA4,0xE4,0x04,0xCE,
		 0x19,0xFC,0xCF,0x77,0x0E,0x5C,0xA1,0xD7},
   
        /*TST_dataSize*/
        32*sizeof(DxUint8_t),       
        CRYS_C2_CBC_mode 
    },
	{ 
        {"Acceptance test - C2/CBC/1-Key/512-ByteData "},
        /*TST_Key*/ 
        { 0x01, 0x03, 0x05, 0x07, 0x09, 0x11, 0x13},
       
 
        /*TST_input_data*/
		{ 0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9},
		
	
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/ 
		{0x8D,0x78,0x84,0x5F,0xDC,0xFA,0x4F,0x45,0xD9,0x03,0x30,0x0A,0x5D,0xF7,0x0B,0x94,0x07,0x55,0xFE,0x2D,0x8A,0xCD,0x49,0x56,0xBE,0x13,0xDE,0x59,0x5B,0xE9,0x04,0xD2,0x6D,0xFE,0x0D,0x92,0xBC,0x35,0xFF,0x8D,0xD5,0xE7,0x8D,0x53,0x1A,0x98,0x40,0x56,0xB7,0x4D,0x7F,0x9A,0xFE,0x4C,0x14,0xEE,0x49,0x12,0xA6,0xEC,0x40,0xC8,0x04,0xC9,0xA3,0x74,0xD0,0x1A,0xA6,0x0D,0xD0,0x96,0x17,0x08,0x0A,0xF7,0xEE,0xCA,0x28,
		0x7A,0x92,0x2B,0xDE,0x87,0x97,0x6A,0x40,0x68,0x15,0xD0,0x55,0x04,0x2F,0x7F,0xA8,0xD5,0x7E,0x6E,0x1D,0x9C,0x6A,0x31,0xD6,0xD9,0x3A,0x71,0xED,0x10,0xD4,0x45,0xD9,0x1B,0x10,0x94,0xA3,0xB4,0x96,0x6F,0x6F,0x7D,0x36,0x11,0x6D,0x87,0xDF,0xCF,0x9F,0xF7,0xC6,0x29,0x8B,0x4C,0xF3,0x65,0x9F,0x4E,0xA2,0x22,0xBF,0xF5,0x85,0x4E,0xC2,0xFA,0x1E,0x85,0x37,0x51,0xB5,0x88,0x5A,0xE6,0x65,0xC0,0x53,0xAD,0xF0,0x58,
		0xD2,0x72,0x61,0xB5,0x54,0xF1,0x26,0xC0,0x40,0x22,0x61,0xA7,0x43,0x52,0x88,0x02,0x84,0xE4,0xA6,0x49,0xB8,0x3F,0x36,0x5C,0x0D,0x1E,0xD0,0x32,0xC1,0x24,0xC8,0x1D,0x70,0xE3,0x0D,0xD9,0x67,0x84,0x17,0xB2,0x77,0x0E,0xBB,0xA1,0xEF,0x84,0x7C,0x1F,0xD9,0xF2,0x2E,0x40,0xB6,0x43,0x3D,0x08,0xDE,0x24,0x58,0x5B,0xBD,0x53,0x26,0xC3,0x17,0xB8,0xA3,0x59,0xBE,0x3A,0x80,0x7A,0xC4,0xD2,0xCA,0x09,0xFB,0x08,0x21,
		0xEA,0x19,0x7D,0xC3,0x16,0x17,0x3E,0xC2,0xD5,0x45,0x29,0xF0,0xFC,0x99,0x40,0x74,0xA0,0x03,0x4D,0xA7,0x75,0x12,0x6C,0x86,0xDE,0xBF,0x9C,0x8D,0x78,0x51,0xFE,0xB2,0x97,0xFC,0xE7,0xCC,0x17,0x3B,0x55,0x5F,0x65,0x42,0xC7,0xAB,0xDB,0x39,0xAF,0x8E,0x11,0xD9,0xAA,0x82,0x65,0x0E,0x11,0xB3,0x2C,0xA1,0x26,0x28,0x19,0xAD,0x70,0x21,0xDD,0xC8,0x65,0x60,0xEB,0xC9,0x3A,0x32,0xB8,0x3A,0x86,0x10,0x0F,0x34,0x30,0xE5,0xFC,0x59,0x12,0x0F,0xB8,0x87,0x92,0x47,0xA6,0x82,0xAF,0x05,0x16,0xAE,0x8F,0x70,0xD3,0x6D,0x4A,0xB5,0xD7,0x7E,0x9B,0x4A,0x5E,0x31,0x55,0x47,0xB6,0xF4,0xD7,0x71,0xD1,0xF2,0xAA,0xBF,0x82,0x04,0x54,0x8A,0x4B,0x79,0xC2,0x77,0x17,0x27,0x60,0x8C,0xCC,0xD5,0xEF,0xBE,0x60,0xEB,0x35,0xC7,0xF3,0x83,0xC8,0x04,0x31,0x10,0xFC,0xC2,0xEF,0x35,0x96,0xBB,0x21,0x87,0xF1,0x1D,0x49,0xB3,0x69,0x4D,0xE9,0xDC,0x97,0x36,0x65,0x53,0x67,0xC3,0xEF,0x00,0x0F,0x19,0x70,0x81,0x2E,0xDC,0xF8,0xA0,0xB7,0x64,0xEB,0xEE,0x63,0xF4,0x05,0x4E,0x5D,0x2B,0xCD,0xD1,0x86,0xFB,0xBB,0x8F,0xE7,0xFB,0x96,0x0B,0xEC,0x2F,0x17,0x0D,0xD7,0xEF,0xEF,0x71,0x50,0xE8,0x37,0x7C,0xFB,0xD6,0x5A,0xAA,0xD2,0xE1,0x95,0x3D,0x15,0x94,0x32,0x3A,0x9A,0x25,0xC2,0x69,0x09,0x41,0x6B,0x8E,0x89,0xEF,0x5B,0x10,0x33,0xA6,0x61,0x71,0xD2,0xDD,0x41,0xE6,0xB0,0x77,0x29,0xB1,0xD5,0x08,0xB9,0x24,0x15,0x3A,0x2E,0xF7,0x84,0x4E,0x1C,0x1D,0x72,0xEB,0xC1,0x68,0xE0,0x48,0x39,0x6C,0xA9,0x55,0xE3,0x23,0xEE,0xB3,0x06,0x18,0xE6,0x15,0xBD,0x36,0x0A},
   
        /*TST_dataSize*/
        512*sizeof(DxUint8_t),       
        CRYS_C2_CBC_mode 
    },   
	{ 
        {"Acceptance test - C2/CBC/1-Key/1024-ByteData "},
        /*TST_Key*/ 
        { 0x01, 0x03, 0x05, 0x07, 0x09, 0x11, 0x13},
       
 
        /*TST_input_data*/
		{
		  0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
		 0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/ 
		{0x8D,0x78,0x84,0x5F,0xDC,0xFA,0x4F,0x45,0xD9,0x03,0x30,0x0A,
		0x5D,0xF7,0x0B,0x94,0x07,0x55,0xFE,0x2D,0x8A,0xCD,0x49,0x56,
		0xBE,0x13,0xDE,0x59,0x5B,0xE9,0x04,0xD2,0x6D,0xFE,0x0D,0x92,
		0xBC,0x35,0xFF,0x8D,0xD5,0xE7,0x8D,0x53,0x1A,0x98,0x40,0x56,
		0xB7,0x4D,0x7F,0x9A,0xFE,0x4C,0x14,0xEE,0x49,0x12,0xA6,0xEC,
		0x40,0xC8,0x04,0xC9,0xA3,0x74,0xD0,0x1A,0xA6,0x0D,0xD0,0x96,
		0x17,0x08,0x0A,0xF7,0xEE,0xCA,0x28,0x7A,0x92,0x2B,0xDE,0x87,
		0x97,0x6A,0x40,0x68,0x15,0xD0,0x55,0x04,0x2F,0x7F,0xA8,0xD5,
		0x7E,0x6E,0x1D,0x9C,0x6A,0x31,0xD6,0xD9,0x3A,0x71,0xED,0x10,
		0xD4,0x45,0xD9,0x1B,0x10,0x94,0xA3,0xB4,0x96,0x6F,0x6F,0x7D,
		0x36,0x11,0x6D,0x87,0xDF,0xCF,0x9F,0xF7,0xC6,0x29,0x8B,0x4C,
		0xF3,0x65,0x9F,0x4E,0xA2,0x22,0xBF,0xF5,0x85,0x4E,0xC2,0xFA,
		0x1E,0x85,0x37,0x51,0xB5,0x88,0x5A,0xE6,0x65,0xC0,0x53,0xAD,
		0xF0,0x58,0xD2,0x72,0x61,0xB5,0x54,0xF1,0x26,0xC0,0x40,0x22,0x61,0xA7,0x43,0x52,0x88,0x02,0x84,0xE4,
		0xA6,0x49,0xB8,0x3F,0x36,0x5C,0x0D,0x1E,0xD0,0x32,0xC1,0x24,0xC8,0x1D,0x70,0xE3,0x0D,0xD9,0x67,0x84,
		0x17,0xB2,0x77,0x0E,0xBB,0xA1,0xEF,0x84,0x7C,0x1F,0xD9,0xF2,0x2E,0x40,0xB6,0x43,0x3D,0x08,0xDE,0x24,
		0x58,0x5B,0xBD,0x53,0x26,0xC3,0x17,0xB8,0xA3,0x59,0xBE,0x3A,0x80,0x7A,0xC4,0xD2,0xCA,0x09,0xFB,0x08,
		0x21,0xEA,0x19,0x7D,0xC3,0x16,0x17,0x3E,0xC2,0xD5,0x45,0x29,0xF0,0xFC,0x99,0x40,0x74,0xA0,0x03,0x4D,
		0xA7,0x75,0x12,0x6C,0x86,0xDE,0xBF,0x9C,0x8D,0x78,0x51,0xFE,0xB2,0x97,0xFC,0xE7,0xCC,0x17,0x3B,0x55,
		0x5F,0x65,0x42,0xC7,0xAB,0xDB,0x39,0xAF,0x8E,0x11,0xD9,0xAA,0x82,0x65,0x0E,0x11,0xB3,0x2C,0xA1,0x26,
		0x28,0x19,0xAD,0x70,0x21,0xDD,0xC8,0x65,0x60,0xEB,0xC9,0x3A,0x32,0xB8,0x3A,0x86,0x10,0x0F,0x34,0x30,
		0xE5,0xFC,0x59,0x12,0x0F,0xB8,0x87,0x92,0x47,0xA6,0x82,0xAF,0x05,0x16,0xAE,0x8F,0x70,0xD3,0x6D,0x4A,
		0xB5,0xD7,0x7E,0x9B,0x4A,0x5E,0x31,0x55,0x47,0xB6,0xF4,0xD7,0x71,0xD1,0xF2,0xAA,0xBF,0x82,0x04,0x54,
		0x8A,0x4B,0x79,0xC2,0x77,0x17,0x27,0x60,0x8C,0xCC,0xD5,0xEF,0xBE,0x60,0xEB,0x35,0xC7,0xF3,0x83,0xC8,
		0x04,0x31,0x10,0xFC,0xC2,0xEF,0x35,0x96,0xBB,0x21,0x87,0xF1,0x1D,0x49,0xB3,0x69,0x4D,0xE9,0xDC,0x97,
		0x36,0x65,0x53,0x67,0xC3,0xEF,0x00,0x0F,0x19,0x70,0x81,0x2E,0xDC,0xF8,0xA0,0xB7,0x64,0xEB,0xEE,0x63,
		0xF4,0x05,0x4E,0x5D,0x2B,0xCD,0xD1,0x86,0xFB,0xBB,0x8F,0xE7,0xFB,0x96,0x0B,0xEC,0x2F,0x17,0x0D,0xD7,
		0xEF,0xEF,0x71,0x50,0xE8,0x37,0x7C,0xFB,0xD6,0x5A,0xAA,0xD2,0xE1,0x95,0x3D,0x15,0x94,0x32,0x3A,0x9A,
		0x25,0xC2,0x69,0x09,0x41,0x6B,0x8E,0x89,0xEF,0x5B,0x10,0x33,0xA6,0x61,0x71,0xD2,0xDD,0x41,0xE6,0xB0,
		0x77,0x29,0xB1,0xD5,0x08,0xB9,0x24,0x15,0x3A,0x2E,0xF7,0x84,0x4E,0x1C,0x1D,0x72,0xEB,0xC1,0x68,0xE0,
		0x48,0x39,0x6C,0xA9,0x55,0xE3,0x23,0xEE,0xB3,0x06,0x18,0xE6,0x15,0xBD,0x36,0x0A,0xCF,0x26,0x83,0xF8,
		0x8F,0x66,0x29,0xC4,0x46,0x8E,0x8F,0x99,0x22,0x1E,0x7B,0x1B,0xA2,0xC7,0x4E,0xE4,0xA1,0xF6,0x16,0x68,
		0x5F,0x8A,0x41,0x72,0x3C,0x68,0x32,0x0B,0xB1,0x65,0x8E,0x87,0x90,0x91,0xB0,0xDF,0x0F,0x41,0xCD,0x4F,
		0xEE,0x99,0xE4,0x1E,0xD9,0xFE,0xA1,0x08,0x0E,0xF1,0x3C,0x5B,0xD1,0x2E,0x4E,0x00,0x31,0xCF,0x41,0x4C,
		0x48,0xAC,0xA8,0x02,0x48,0xC0,0x05,0x9A,0x08,0xF1,0x85,0x2A,0x91,0x3A,0xD8,0xF1,0x9F,0xE1,0xCC,0x1D,
		0xC5,0xE4,0xE6,0x88,0xC2,0x64,0xB2,0x06,0xD5,0x3D,0x0F,0x58,0xB0,0xA3,0x17,0xD6,0x34,0x8F,0x5C,0x70,
		0x31,0xA4,0xD6,0x44,0x30,0x1F,0x2C,0xDD,0xBB,0xCF,0x11,0x42,0x8E,0xC8,0x2D,0x45,0xE6,0xAB,0x3B,0xFF,
		0x5D,0xFC,0x8B,0xC6,0xFC,0x6D,0x9B,0xA7,0x51,0x11,0x8E,0xFE,0x6F,0xB6,0x3B,0xBC,0x04,0xA2,0x32,0x1D,
		0x3C,0x5A,0x6D,0x08,0xC2,0x83,0xD5,0x36,0xA2,0x99,0x1C,0xFD,0xAC,0xA7,0x7B,0xF7,0xE6,0xF2,0xDE,0x05,
		0xCE,0xD3,0x44,0xA3,0x3C,0x7A,0xCA,0x88,0x7A,0x0F,0x3B,0x5F,0xB5,0x99,0x2F,0x0E,0xF1,0x89,0x16,0xC9,
		0x4D,0xE0,0x43,0xE9,0x0A,0xF9,0xB9,0xD6,0xC4,0x0F,0x51,0xAE,0x0E,0x4F,0x7C,0xC9,0x4E,0x45,0x43,0x3A,
		0x01,0x3F,0x25,0x5A,0x99,0x8B,0x6B,0xC4,0xFE,0x50,0x6E,0x1F,0x31,0x2A,0x09,0xC0,0x68,0x00,0xBB,0xB2,
		0x66,0x68,0x49,0xE7,0x96,0x37,0x59,0x4A,0x96,0x5D,0x51,0xCE,0xE1,0xC3,0xFB,0xA4,0x2F,0x89,0xAF,0x5C,
		0xDD,0xD9,0xEC,0x49,0x12,0x0F,0xA1,0xB5,0x32,0xA8,0x16,0xD5,0x35,0x19,0xB1,0xAD,0xD9,0x57,0x99,0x0A,
		0xF2,0x0D,0x08,0xAC,0x7A,0x1B,0xCE,0x9C,0x9A,0xAA,0x98,0x4E,0x9F,0xE4,0x71,0x66,0x35,0xCE,0xCF,0x34,
		0x5B,0x23,0xC6,0x17,0x0E,0xFE,0x54,0xC9,0x01,0xBE,0xAC,0x93,0x36,0x9B,0x1E,0x98,0x37,0x1B,0xFF,0x8C,
		0x43,0x05,0xE5,0x06,0xE6,0x45,0x8A,0xDA,0x9D,0xC7,0x33,0xC6,0x98,0x53,0x79,0x4C,0x9F,0xC7,0x8D,0x89,
		0x88,0x1B,0x36,0x40,0x05,0x76,0x05,0x00,0x9D,0x8A,0xCC,0xC6,0x3D,0xD4,0x7A,0xD0,0x62,0x0C,0x9A,0xDB,
		0x9A,0xC7,0xE4,0x40,0xB1,0x8E,0xB4,0x47,0x36,0x02,0xDB,0xE3,0x82,0x1E,0x54,0x32,0xB6,0x86,0x80,0x67,
		0x61,0x1D,0x23,0xD7,0xD7,0x82,0x8A,0x08,0x0A,0x70,0x90,0x29,0x0F,0x86,0xBC,0xC7,0x19,0xBB,0x4B,0xF4,
		0x2A,0x76,0x3B,0x30,0x65,0x0C,0xAB,0x62,0xDF,0x36,0x5D,0x0B,0xB6,0x40,0x63,0x0A,0x43,0x44,0x82,0x94,
		0xEA,0xD2,0xC3,0xA8,0x76,0x50,0x3C,0x13,0xC0,0x84,0xB2,0xA3,0xFA,0x89,0x68,0xFF,0xC2,0xEB,0x5C,0x6B,
		0x24,0xBB,0x34,0xE7,0x4B,0x59,0xD8,0xF7,0xE8,0x71,0x7C,0x47,0x0F,0xA6,0xC7,0x86,0x2B,0x51,0x51,0xCA,
		0x3D,0xAD,0x0B,0xE6,0x99,0x9F,0xC6,0x07,0x71,0xD5,0xAA,0xE0,0xE6,0x11,0x22,0xE5,0x01,0x79,0xA7,0x9E,
		0xD3,0xC8,0xC4,0x21,0xA8,0xBE,0xD7,0x54,0x3B,0xC1,0x47,0x9A,0x5F,0xC6,0x9B,0x10,0x01,0x52,0x47,0xC8,
		0x66,0xBA,0x6F,0xFE,0x5B,0x5F,0x6A,0x78,0x93,0x60,0xCF,0x39,0x2F,0xC1,0x5E,0x53,0x13,0x04,0x9F,0xED,
		0x36,0x6C,0x88,0x99,0xAB,0x4C,0x74,0x35},
   
        /*TST_dataSize*/
        1024*sizeof(DxUint8_t),       
        CRYS_C2_CBC_mode 
    },   

};

const int TST_NumberOf_C2_AcceptanceTests = sizeof(TST_C2_Acceptance_TestData)/sizeof(TST_C2_Acceptance_TestData[0]);
TST_C2_HASH_TestDataStruct TST_C2_HASH_Acceptance_TestData[] =
{
        /****************************************/
        /*        HASH C2  vectors              */
        /****************************************/
    { 
        {"Acceptance test x.0 - C2 HASH/16ByteData "},
        /*TST_input_data*/
        {0xd8,0x32,0x46,0xa2, 0x44,0x08,0x32,0x24, 0xdf,0x11,0x81,0x7d, 0x72,0x41,0xe2,0x8c,0xd7,0x42,0xbe,0x76,0x18,0x44,0xb1,0x0d},
        /*TST_input_dataSize*/
        24*sizeof(DxUint8_t),
        /*TST_HashResultBuff*/
        {0}, 
        /*TST_C2_Expected_output_data*/
		{0x299eb6db, 0xeee75099},
        
		
        /*TST_C2_expected_dataSize*/
        CRYS_C2_BLOCK_SIZE_IN_WORDS*sizeof(DxUint8_t),      
    },

	{ 
        {"Acceptance test x.0 - HASH/32ByteData "},
        /*TST_input_data*/
        {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
         0x65,0xa2,0x32,0xd6,0xbc,0xd0,0xf9,0x39,0xed,0x1f,0xe1,0x28,0xc1,0x3b,0x0e,0x1b},
        /*TST_input_dataSize*/
        32*sizeof(DxUint8_t),
        /*TST_HashResultBuff*/
        {0},
        /*TST_SHA1_Expected_output_data*/
		//{0x9f,0x9d,0xa1,0x0e,0xc2,0x37,0x35,0x93},
		{0xb61af514,0x7625c7e7},
        /*TST_SAH1_expected_dataSize*/
        CRYS_C2_BLOCK_SIZE_IN_WORDS*sizeof(DxUint8_t),      
    },
    { 
        {"Acceptance test x.0 - HASH/512ByteData "},
        /*TST_input_data*/
        {0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0xb6,0xed,0x21,0xb9,0x9c,0xa6,0xf4,0xf9,0xf1,0x53,0xe7,0xb1,0xbe,0xaf,0xed,0x1d,
         0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9,
         0x62,0xf8,0xa7,0x23,0x7b,0xbd,0xf8,0x4d,0x4e,0x1d,0xff,0xe8,0xb5,0x2a,0x02,0xc1,
         0x52,0xdb,0x14,0x2f,0xeb,0x21,0xf9,0x58,0xb8,0x80,0x28,0x68,0xe4,0x99,0x06,0x18,
         0x42,0x76,0x4b,0x85,0x1f,0x70,0xc4,0x32,0x8a,0x1a,0x4e,0x87,0x09,0x16,0x6e,0x2e,
         0xc2,0xe5,0x46,0xa5,0xbc,0xaf,0x42,0xc1,0x6b,0x98,0x13,0x20,0x2f,0xa2,0xf4,0xa9},
        /*TST_input_dataSize*/
        512*sizeof(DxUint8_t),
        /*TST_HashResultBuff*/
        {0},
        /*TST_SHA1_Expected_output_data*/
		//{0x71,0x1c,0xc0,0xb0,0xb2,0x25,0x9b,0x2d},
		{0xd1cac642,0xa2b778e2},
        /*TST_SAH1_expected_dataSize*/
        CRYS_C2_BLOCK_SIZE_IN_WORDS*sizeof(DxUint8_t),      
    },
    { 
        {"Acceptance test x.0 - HASH/1536ByteData "},
        /*TST_input_data*/
        {0xc6,0x4c,0xab,0x69,0x8b,0x3f,0x48,0x72,0x11,0x0f,0xf6,0x4d,0x11,0x9b,0xe8,0xf0,
        0xf9,0xaf,0x8d,0xa1,0x49,0xd6,0x12,0x67,0x3d,0x6f,0x28,0xbe,0xac,0x03,0x07,0x8e,
        0x30,0xd6,0xb3,0x5e,0x87,0xbc,0x7e,0xc5,0x39,0x2e,0xce,0x22,0x7b,0x9d,0x20,0x8d,
        0x54,0x06,0x4d,0x0e,0xfe,0xc7,0x0c,0x0c,0x8f,0xb1,0xb9,0x08,0xd9,0x5e,0x55,0x8b,
        0x8e,0xc5,0xcd,0x5c,0xa8,0x0b,0x7f,0xf7,0x07,0x9d,0xfa,0x3b,0x5c,0x7b,0x05,0x63,
        0x47,0xd7,0xe4,0x37,0xbc,0xde,0xd6,0x83,0xab,0xd6,0xe2,0xc9,0xe0,0x69,0xd3,0x33,
        0x28,0x40,0x82,0xcb,0xb5,0xd4,0x53,0xee,0xc3,0x81,0x02,0xfe,0x7c,0xdd,0xa0,0x58,
        0x19,0x47,0xd8,0x86,0x4b,0xc3,0x77,0xb5,0xd9,0x05,0x2c,0x69,0x8a,0xcb,0x8b,0x6f,
        0x45,0x70,0x58,0x14,0x77,0xbe,0x03,0x94,0xb5,0x05,0x6f,0xd5,0xa3,0x69,0xf7,0x55,
        0x14,0x80,0xb3,0x61,0x72,0x1d,0xf7,0x89,0x61,0x66,0x1d,0x50,0x9f,0x2d,0x85,0x28,
        0x2e,0x7d,0xd9,0x9d,0xb6,0x72,0x96,0xd0,0x25,0x4e,0xc8,0x27,0x98,0xca,0x15,0x43,
        0x7e,0xaa,0xfc,0x32,0xfa,0x94,0x5f,0xe6,0x8a,0x22,0x3f,0xe6,0xe7,0x36,0xc8,0x44,
        0x2c,0x8e,0x8d,0xcf,0x39,0x98,0x14,0x89,0x5a,0x87,0x95,0x5c,0x24,0xa6,0xff,0x08,
        0xa0,0xec,0x3c,0x60,0xac,0xd1,0xb6,0xb6,0x9d,0x61,0x1a,0x94,0x29,0x8f,0x5c,0xad,
        0x85,0xcb,0xfb,0x12,0xca,0xd7,0x86,0xa9,0x9d,0xd6,0x5f,0xdc,0x0f,0xa6,0xbf,0x8e,
        0xc2,0x6f,0xfa,0x53,0x4e,0x7c,0x04,0xe0,0xe2,0x4a,0x34,0xc0,0x2f,0xdf,0x49,0x49,
        0x81,0x5d,0xab,0xcf,0x2f,0xd7,0xf3,0x17,0x36,0x63,0xac,0x0e,0x21,0x71,0x5b,0xbb,
        0x2c,0x5b,0xbe,0x73,0xa8,0x3d,0x52,0x4c,0xa1,0x06,0x17,0xd4,0xbf,0xcf,0x97,0x02,
        0x6a,0x6c,0x25,0x6c,0x31,0x41,0x63,0xbb,0x6d,0x57,0x07,0x5c,0x21,0xb0,0xde,0x79,
        0x25,0xd7,0x11,0x28,0x84,0xba,0xa7,0xe2,0x22,0xbc,0x4b,0x36,0xa2,0x07,0x4f,0xbe,
        0x86,0x1f,0xf2,0x53,0x98,0xbd,0xde,0x7d,0x89,0xda,0xf5,0x2d,0xd9,0x0a,0x4d,0xaf,
        0xf6,0x0b,0x79,0xda,0xa8,0x9e,0x0b,0x8a,0xac,0x95,0x56,0x50,0xa0,0x2e,0x79,0x67,
        0x1f,0x9f,0x99,0xea,0x2c,0xf2,0x6d,0x45,0xd4,0x13,0x00,0xea,0x0f,0x28,0xb2,0x45,
        0xe8,0x20,0x80,0xf1,0xdd,0x8f,0x86,0x2c,0x89,0xb9,0xc2,0x88,0x80,0xec,0x1b,0xe4,
        0x7b,0x14,0xa2,0x9b,0xb5,0x89,0x17,0xfb,0x94,0x2b,0xaf,0xf9,0x8c,0xb1,0x14,0x22,
        0x41,0x3e,0xae,0xd5,0xeb,0x35,0x21,0xb0,0xff,0x4f,0x17,0x48,0x0c,0xeb,0x3f,0x1d,
        0xe2,0xa5,0x96,0xcd,0xfa,0x29,0xe5,0x87,0x12,0x4a,0x8a,0xc3,0x18,0x4e,0x7c,0x30,
        0x49,0x8c,0x8a,0xee,0x9a,0x3a,0xe3,0xfe,0x57,0x80,0xdb,0xf7,0x0a,0xd0,0xec,0xfa,
        0x9e,0x7a,0xfb,0xe7,0xc4,0x7b,0xdd,0xd1,0x96,0x96,0x1a,0xb0,0x7a,0xa7,0xf1,0x56,
        0x4a,0x33,0x9c,0xa5,0xb2,0x43,0xd5,0xfe,0xd9,0x73,0x98,0xfc,0x43,0x46,0x2b,0x63,
        0xf6,0xbc,0x5c,0x53,0xdb,0x27,0x0a,0xc2,0x68,0x3a,0xe6,0x29,0x7c,0x63,0x7b,0x7c,
        0x8a,0x5b,0x6c,0x60,0xfa,0xfb,0xfd,0x99,0xcc,0x51,0xd5,0xc1,0x7f,0xf3,0x03,0x40,
        0x31,0x93,0x3e,0x78,0x07,0xd4,0x71,0x40,0xcf,0x5c,0x77,0x94,0xe4,0x2a,0x22,0x8a,
        0x52,0x2a,0x83,0x88,0x3b,0x07,0x65,0xb5,0x7a,0x41,0x1b,0xad,0x85,0x7f,0x7c,0x79,
        0x98,0x26,0x2b,0xbe,0x10,0x2a,0x1c,0x34,0x15,0x25,0x53,0x5a,0x7b,0xa6,0xef,0x69,
        0xea,0xcb,0x68,0x86,0x3d,0x12,0x15,0x3b,0x29,0x6c,0xf1,0x28,0x1f,0x93,0x9e,0xf6,
        0x73,0x9e,0xaa,0x8d,0xbd,0xd3,0x12,0x87,0x80,0xbc,0x04,0xe4,0x09,0x7d,0xe9,0xff,
        0x9a,0x64,0xa3,0xc0,0xc8,0xc2,0x13,0x14,0x22,0xf9,0xdf,0x9a,0x13,0xd7,0x72,0xa0,
        0x0a,0x22,0x44,0x4d,0xd7,0x74,0x5b,0x1f,0x59,0x49,0x12,0x99,0x56,0x57,0x19,0x35,
        0xaa,0x1e,0xbd,0xa0,0xa4,0xbf,0x69,0x26,0xad,0x11,0x6d,0x6b,0x2a,0xf2,0xff,0x5d,
        0xa4,0xdb,0x7f,0x66,0x26,0xb8,0x00,0xe6,0xe7,0xf6,0x03,0xe0,0x29,0xdd,0x85,0xf4,
        0x61,0x20,0x3d,0x8d,0x98,0xb2,0x1f,0x5b,0x11,0xdc,0x24,0x04,0x2c,0x8d,0x4d,0x16,
        0x8a,0xf1,0xe6,0x41,0x72,0x44,0x08,0xc3,0x74,0xe9,0x61,0x23,0x4c,0xb6,0x37,0x22,
        0x09,0x93,0xab,0xef,0x6e,0x43,0x3b,0x9a,0x98,0x81,0x8b,0xcb,0xe1,0x4f,0x65,0xb4,
        0x05,0x8b,0xfe,0x44,0x83,0xc3,0x7b,0x9d,0x46,0x4a,0xb3,0xc9,0x85,0x8b,0x37,0xa8,
        0xe8,0x9e,0x90,0x2d,0xec,0x19,0xc7,0xca,0x88,0x29,0x2b,0x29,0x11,0xe1,0x4e,0x1d,
        0x5b,0xd1,0x51,0xd8,0x21,0xdb,0x61,0x5e,0xa6,0x42,0x82,0x3a,0x9d,0x04,0x8b,0x6f,
        0x46,0x6a,0x72,0xb1,0xdb,0xdd,0xca,0xd5,0x2a,0xfb,0x8a,0x87,0x83,0xea,0x10,0x3b,
        0xd4,0xec,0x66,0x66,0x13,0x34,0xc3,0xed,0xdc,0xf9,0x55,0xdd,0x5c,0xc8,0x3d,0x5e,
        0x6d,0x1e,0xdc,0xe2,0x02,0x36,0x4d,0xa2,0xc6,0x20,0x32,0x4b,0x00,0x13,0xb4,0xf4,
        0xba,0x04,0xc5,0x54,0x22,0x77,0xa8,0x32,0x30,0x96,0xb4,0x1c,0x89,0x80,0x55,0x5c,
        0xa4,0xe3,0x53,0x28,0x2b,0xcd,0x57,0x19,0xa4,0xbf,0xab,0xdf,0x50,0x04,0x41,0x32,
        0x53,0x40,0xf7,0x0b,0x16,0x4c,0x19,0x15,0xea,0x41,0x27,0x5e,0xee,0xd3,0xd9,0x53,
        0x32,0xe1,0x61,0xeb,0x1c,0x49,0xf0,0x22,0x0b,0x01,0x7b,0xa9,0x3b,0x64,0xbf,0xdc,
        0xe9,0xc9,0x83,0xf4,0xb7,0x5a,0x1d,0x7e,0x51,0x24,0x37,0x0c,0x51,0x6a,0xd3,0x2a,
        0x60,0x3f,0x8d,0x93,0x9e,0x54,0x20,0xa5,0x45,0x0e,0x2c,0x13,0x89,0xdb,0x37,0xda,
        0xc2,0xc7,0xf1,0x76,0xcc,0x4a,0xbc,0x55,0xae,0x64,0x6b,0x8c,0x7b,0xec,0x4a,0xc9,
        0x76,0x26,0x5f,0x88,0x79,0x93,0xf0,0x8a,0x98,0x0d,0x46,0x83,0x01,0x13,0xb0,0x14,
        0x26,0x61,0xca,0xf8,0x1f,0xc3,0xfe,0x82,0x49,0x2c,0x4c,0x47,0x34,0x02,0x47,0x18,
        0xbc,0xbd,0x60,0x33,0x75,0xb0,0x67,0xb9,0x4d,0x26,0x4f,0x63,0x6c,0xb1,0x32,0x71,
        0x5f,0xbf,0x94,0xe4,0x76,0x6e,0xec,0xed,0x6a,0xa2,0x61,0xa5,0x43,0x54,0xd1,0xfe,
        0x79,0x2d,0x17,0xfa,0x5a,0x53,0x8e,0x1b,0xab,0x83,0xd1,0x1a,0x92,0x60,0xc5,0xdc,
        0xb4,0x0a,0xda,0xa1,0x9a,0xf3,0x8d,0x7f,0x59,0xee,0x32,0x0f,0x72,0x89,0xf0,0x66,
        0xf7,0x9d,0x0d,0x46,0xef,0x23,0x6b,0x96,0xfc,0x49,0x53,0x10,0x3b,0xc6,0x72,0x3a,
        0x6c,0x6a,0x21,0x97,0x53,0xf9,0xea,0x1e,0x5d,0x39,0x47,0xeb,0x87,0x4a,0xac,0x35,
        0x7c,0x36,0xc8,0x80,0xfd,0xc9,0x09,0x13,0x86,0xa3,0x5e,0xad,0x2f,0x8b,0x40,0x74,
        0xd0,0x06,0xf3,0x2e,0x68,0x28,0x09,0xb3,0xc0,0xab,0x29,0xa2,0x4b,0x3e,0x0e,0x54,
        0x51,0x1f,0xd2,0x0e,0x4c,0xec,0x6d,0x7b,0x93,0xb7,0x79,0x59,0x35,0x58,0x38,0x72,
        0x28,0x07,0xd7,0xce,0xa3,0x2a,0xf4,0x27,0xc8,0x6b,0x5f,0x9d,0x86,0x0e,0x1d,0xab,
        0xbe,0x81,0xb3,0x5a,0xa4,0x35,0xa1,0xb4,0x69,0xad,0x2c,0x7c,0x17,0xd5,0x60,0x1c,
        0xbc,0x94,0x56,0xdf,0xca,0xa4,0xb3,0x60,0xbe,0xa2,0x71,0x43,0x00,0x61,0xe2,0x22,
        0x0a,0x84,0xf1,0xca,0xcd,0x4c,0xac,0xa8,0x50,0xae,0xff,0x7e,0x9b,0xa9,0xc2,0x5a,
        0xd3,0xd6,0xf7,0xc9,0xa6,0x41,0x4c,0x48,0xea,0x77,0xe8,0xfb,0x80,0xe0,0x63,0xa2,
        0x7f,0x4f,0x16,0xc8,0x8e,0xd8,0x96,0x3d,0x92,0xe2,0x7b,0xc7,0x8a,0x7c,0x66,0x15,
        0xb6,0xf5,0x42,0xf4,0xff,0xa6,0xc9,0xc6,0x93,0x13,0x4a,0x2f,0xd0,0x33,0xaa,0x11,
        0x63,0x0b,0xaa,0xbb,0xb1,0x82,0x67,0x5d,0x76,0x70,0x27,0xbf,0xab,0xf8,0x52,0x33,
        0xae,0x18,0xbf,0xc9,0x9d,0x7e,0x31,0xc1,0x02,0x9d,0x22,0x46,0xb6,0x01,0xbf,0x59,
        0xff,0xdf,0x33,0x0b,0xfc,0xf1,0x28,0xef,0x43,0x80,0x8b,0xcf,0xc8,0xc3,0x90,0x9e,
        0x01,0x67,0xf7,0xae,0x47,0x6f,0x8d,0x23,0x80,0x3e,0xf5,0xa8,0xfb,0xf2,0xa8,0x60,
        0x9b,0xf4,0x3b,0x1f,0x38,0xcd,0xe1,0xdb,0x42,0x3c,0x30,0x5d,0xa7,0x85,0x28,0x3c,
        0xf7,0x0b,0x71,0x0c,0xc7,0x21,0xe4,0xd3,0x53,0x1e,0x4d,0xbc,0x67,0xaf,0x6f,0x10,
        0x7f,0x72,0x49,0x61,0x2d,0xc0,0x98,0x09,0xbb,0xca,0x9d,0xd3,0x11,0xe7,0x20,0xf7,
        0xda,0x2c,0xb5,0x4c,0xe3,0x3e,0x3e,0xb9,0xc3,0x64,0xb1,0xec,0xc1,0xe0,0x1c,0x4f,
        0xf2,0x80,0xe6,0x38,0xa2,0x70,0x57,0x61,0xf5,0x52,0x5a,0x97,0xce,0x90,0x82,0xb6,
        0xf0,0xf1,0x4c,0xd4,0x64,0x6b,0xa4,0xbd,0x1a,0x39,0xaa,0xa0,0xd3,0x2d,0xb5,0x07,
        0x3d,0x46,0x98,0x0c,0x60,0x85,0x25,0xca,0x3a,0xfd,0xf0,0x13,0xa6,0x2a,0x56,0x61,
        0x83,0x83,0xbd,0x0e,0x11,0x52,0x1c,0xc7,0x9e,0xc4,0xbf,0x3e,0x63,0x3c,0x44,0x1f,
        0xa9,0xed,0xea,0x46,0x30,0xa8,0x0b,0x2f,0xd0,0xf2,0xe6,0xad,0x61,0x5a,0xa2,0xdf,
        0xd9,0x0a,0x90,0x60,0xb4,0x9b,0xb1,0xbf,0x99,0x2e,0x78,0x2f,0x3a,0xb8,0xd0,0x7f,
        0x7c,0x9d,0x61,0x4c,0xd8,0x81,0x0f,0x75,0x00,0x5a,0xc4,0xcf,0xc6,0xca,0x70,0x1a,
        0x3a,0xad,0x4e,0x34,0x13,0xee,0x68,0x8d,0x51,0x9e,0x5d,0xdb,0x20,0x47,0x62,0x0f,
        0xfe,0x7d,0x87,0x87,0x20,0xb7,0x3c,0x85,0x12,0x5d,0x13,0xe0,0x9f,0x22,0xc7,0xf9,
        0xf0,0x94,0x7e,0xf1,0xf8,0xf1,0x4b,0x19,0x0f,0x3d,0xf7,0xaa,0xdc,0x91,0x01,0xb7,
        0x79,0xb6,0xe3,0x5f,0xd2,0xf3,0x97,0x47,0x4e,0x22,0x5a,0x48,0xb2,0x09,0xb0,0x64,
        0x42,0xe8,0xa8,0xff,0x29,0x4f,0x61,0x4b,0x1a,0x32,0xcd,0x05,0x38,0x3f,0xb5,0x5f,
        0x33,0x6f,0xfd,0x3d,0xb4,0xdc,0x2a,0xa3,0xfc,0xd2,0x21,0x6e,0xc8,0x28,0x31,0x43},
        /*TST_input_dataSize*/
        1536*sizeof(DxUint8_t),
        /*TST_HashResultBuff*/
        {0},
        /*TST_SHA1_Expected_output_data*/
		//{0xeb,0xc1,0x56,0xa7,0x02,0xf6,0x65,0xeb}, 
        {0x4e6a2aa2,0x0bd78615},
		/*TST_SAH1_expected_dataSize*/
        CRYS_C2_BLOCK_SIZE_IN_WORDS*sizeof(DxUint8_t),      
            },
   
};

const int TST_NumberOfC2HASHAcceptanceTests = sizeof(TST_C2_HASH_Acceptance_TestData)/sizeof(TST_C2_HASH_Acceptance_TestData[0]);

TST_C2_OneWayFunc_TestDataStruct TST_C2_OneWayFunc_Acceptance_TestData[] =
{
        /****************************************/
        /*        OneWayFunc C2  vectors              */
        /****************************************/
    { 
        {"Acceptance test x.0 - C2 One Way Function/8ByteData "},
		/*TST_Key*/ 
        { 0x5e, 0x91, 0x6a, 0xef, 0x34, 0x1f, 0xa3},  
		/*TST_input_data*/
        { 0x2b, 0x7f, 0x06, 0x89, 0x6f, 0x0d, 0xa6, 0xe2},
        /*TST_input_dataSize*/
        8*sizeof(DxUint8_t),
        /*TST_ResultBuff*/
        {0}, 
        /*TST_OneWayFunc_Expected_output_data*/
		{  0xcf, 0x20, 0xe0, 0x06, 0x6a, 0x8d, 0x1c, 0x15},
		
    },
   

};

const int TST_NumberOfC2OneWayFuncAcceptanceTests = sizeof(TST_C2_OneWayFunc_Acceptance_TestData)/sizeof(TST_C2_OneWayFunc_Acceptance_TestData[0]);
		  

